<?php
/**
 * Created by G. Kipouros for Exis.com.gr
 * User: gkipouros
 * Date: 30/9/2018
 */

error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('memory_limit', '1024M');

if( php_sapi_name() !== 'cli' && $_SERVER['HTTP_HOST'] !='localhost' ) {
    die("Meant to be run from command line");
}


include (dirname(__FILE__)."/functions.php");
include (dirname(__FILE__)."/config.php");
define('BASE_PATH', exis_find_wordpress_base_path()."/" );
define('WP_USE_THEMES', false);
$startime=getmicrotime();

require(BASE_PATH . 'wp-load.php');

ini_set('display_errors', 1);
echo exis_show_run_time("WP files loaded");

if ( ! function_exists( 'wp' ) )
    die( 'Sorry, looks like WordPress isn\'t loaded.' );

$sql = "SELECT * FROM taxiplon_pricing";
$results = $wpdb->get_results($sql);
foreach ($results as $pricing) {
    $existing_pricing[$pricing->location][$pricing->zone][$pricing->taxi_id] = true;
}

$updated_counter = 0;
$h = fopen($csv['prices'], "r");
$current_data = array();
while (($row = fgetcsv($h, 1000, ";")) !== FALSE) {

    $current_data['taxi_id']           = $data['car_types'][$row['2']]['id'];
    $current_data['zone']              = trim($row[0]);
    $current_data['location']          = $data['locations'][$row['1']];
    $current_data['price_normal_to']   = trim($row[3]);
    $current_data['price_double_to']   = trim($row[4]);
    $current_data['price_normal_from'] = trim($row[5]);
    $current_data['price_double_from'] = trim($row[6]);

    if ($current_data['zone']<1 || $current_data['zone'] > 100) {
        continue;
    }

    // Check if location/zone/taxi_id already exists
    if ($existing_pricing[$current_data['location']][$current_data['zone']][$current_data['taxi_id'] ]) {

        // Update row
        $update_data = array (
                'price_normal_to'   => $current_data['price_normal_to'],
                'price_double_to'   => $current_data['price_double_to'],
                'price_normal_from' => $current_data['price_normal_from'],
                'price_double_from' => $current_data['price_double_from']
        );
        $where_data = array(
                'location'          => $current_data['location'],
                'zone'              => $current_data['zone'],
                'taxi_id'           => $current_data['taxi_id']
        );
        $result = $wpdb->update('taxiplon_pricing', $update_data, $where_data);
        $updated_counter++;
    } else {
        // Insert new row
        $insert_data = array (
                'location'          => $current_data['location'],
                'zone'              => $current_data['zone'],
                'taxi_id'           => $current_data['taxi_id'],
                'price_normal_to'   => $current_data['price_normal_to'],
                'price_double_to'   => $current_data['price_double_to'],
                'price_normal_from' => $current_data['price_normal_from'],
                'price_double_from' => $current_data['price_double_from']
        );

        $result = $wpdb->insert('taxiplon_pricing', $insert_data);
        $inserted_ids[] = $wpdb->insert_id;
    }



}
echo "<h3>Inserted ".count($inserted_ids)." rows and Updated ".$updated_counter." rows!</h3>";

fclose($h);