<?php
/* Template Name: Available Taxis (Search results) */

get_header();

$container   = get_theme_mod( 'understrap_container_type' );
remove_filter('the_content', 'wpautop');

// Get pricing per post_code per port/airport per car
$sql = "SELECT tp.*, tz.post_code FROM	taxiplon_pricing AS tp,	taxiplon_zones AS tz WHERE	tp.`zone` = tz.zone";
$results = $wpdb->get_results($sql, ARRAY_A);
foreach ($results as $data) {
	$pricing[$data['post_code']][$data['location']][$data['taxi_id']]['price_normal_to'] 	= $data['price_normal_to'];
	$pricing[$data['post_code']][$data['location']][$data['taxi_id']]['price_double_to'] 	= $data['price_double_to'];
	$pricing[$data['post_code']][$data['location']][$data['taxi_id']]['price_normal_from'] = $data['price_normal_from'];
	$pricing[$data['post_code']][$data['location']][$data['taxi_id']]['price_double_from'] = $data['price_double_from'];
}


$data = array();
if ($_GET){
	$data['pick-up-select'] = sanitize_text_field($_GET['pick-up-select']);
	$data['pick-up-location'] = sanitize_text_field($_GET['pick-up-location']);
	$data['pick-up-post-code'] = sanitize_text_field($_GET['pick-up-post-code']);

	$data['drop-off-select'] = sanitize_text_field($_GET['drop-off-select']);
	$data['drop-off-location'] = sanitize_text_field($_GET['drop-off-location']);
	$data['drop-off-post-code'] = sanitize_text_field($_GET['drop-off-post-code']);
	$data['pick-up-date'] = sanitize_text_field($_GET['pick-up-date']);
	$data['pick-up-time'] = sanitize_text_field($_GET['pick-up-time']);
	$data['pick-up-date-time'] = $data['pick-up-date']. " ".$data['pick-up-time'];
	$data['return-journey'] = ($_GET['return-journey']=='on'?true:false);
	$data['passengers'] = sanitize_text_field($_GET['passengers']);
	$data['return-date'] = sanitize_text_field($_GET['return-date']);
	$data['return-time'] = sanitize_text_field($_GET['return-time']);

}
?>

<div class="wrapper " id="page-wrapper">

	<div class="<?php echo esc_attr( $container ); ?>" id="content" tabindex="-1">
		<div class="row">

			<main class="site-main" id="main">
				<div class="row flex-row-reverse">
					<div class="col-md-12 col-lg-8">
						<div id="available-cars">
							<h1><?php echo __('Vehicle Type', 'taxiplon');?></h1>
							<?php
							$error = false;
							// Check if both pick up and drop off are not addresses.
							if (empty($data)) {
								$error[] = __("Please select a journey on the left form, to see all available taxis and prices.","taxiplon");
							}
							date_default_timezone_set('Europe/Athens');
							$pick_up_timestamp = strtotime(str_replace('/', '-', $data['pick-up-date-time']));
							
							if ($pick_up_timestamp < time()){

								$error[] = __("The time you have selected for pickup has already passed!<br />Please select a different date and/or time.","taxiplon");
							}

							if (!strstr($data['pick-up-select'], 'other') && !strstr($data['drop-off-select'],"other")) {
								$error[] = __("This service is only from or to a port or airport and your address. Please select a specific address to Pick-up or Drop-off location.","taxiplon");
							}
							else {
								if (strstr($data['pick-up-select'], 'other')) {
									$data['post_code'] 		= $data['pick-up-post-code'];
									$data['from_location'] 	=  $data['drop-off-select'];
									$data['trip_type']		= 'to';
								}
								elseif (strstr($data['drop-off-select'],"other")) {
									$data['post_code'] 		= $data['drop-off-post-code'];
									$data['from_location'] 	=  $data['pick-up-select'];
									$data['trip_type']		= 'from';
								}
							}


							// Check if post code exists in Database
							if ($pricing[$data['post_code']][$data['from_location']] == null) {
								$error[] = __("We are sorry but the address you entered is out of our service. Please try a different journey.","taxiplon");
							}

							// Check if return date exists and if it is before pickup date
							$pick_up_datetime = $data['pick-up-date']." ".$data['pick-up-time'];
							$return_datetime = $data['return-date']." ".$data['return-time'];
							if ($return_datetime <= $pick_up_datetime && $data['return-journey']) {
								//$data['return-journey']
								$error[] = __("The selected return date and time is before the departure date and time. Please select a different time for return.","taxiplon");
							}

							if (!empty($error)) {
								?>
								<div class="results-error">
									<h3><i class="fas fa-exclamation-triangle"></i> <?php echo __('An error occured!','taxiplon');?></h3>
									<?php echo $error[0]; ?>
								</div>
								<?php
							}
							else {
								$prop_no = 50;
								$paged = ( get_query_var('page') ) ? get_query_var('page') : 1;

								// pricing cars for specific locations

								$taxi_prices = $pricing[$data['post_code']][$data['from_location']];

								$taxi_ids = array();
								$taxi_ids = array_keys ($taxi_prices);
								// Do not show anything if no taxi ids
								if (count($taxi_ids)== 0) {$taxi_ids[] = 0;}

								$args = array(
										'post_type'       => 'product',
										'post_status'     => 'publish',
										'paged'           => $paged,
										'posts_per_page'  => $prop_no,
										'meta_key' 				=> 'passengers',
										'meta_value' 			=> $data['passengers'],
										'meta_compare' 		=> '>=',
										'orderby'					=> 'meta_value_num',
										'order'						=> 'asc',
										'post__in'				=> $taxi_ids,
										'meta_type'    => 'numeric',
										);


								//var_dump($args);exit;
								$results = new WP_Query($args);
								if($results->have_posts()) {
									while($results->have_posts()) {
									 $results->the_post();
									 $post_meta  = get_post_meta($post->ID);
									 $taxi_id 	 = get_the_ID();
									 $obj_taxi_id = $taxi_id;
									 if (ICL_LANGUAGE_CODE != "en"){
										 $obj_taxi_id = icl_object_id($taxi_id, 'page', false, 'en');
									 }


									 // Find trip to and from directions
									 if ($data['trip_type'] == 'to') {
										 $trip_type			= "_to";
										 $trip_type_return	= '_from';
									 } elseif ($data['trip_type'] == 'from') {
										 $trip_type			="_from";
										 $trip_type_return 	= '_to';
									 } else {
										 die ("Error 21: Could not get prices.");
									 }

									 // Get one way price
									if ($data['pick-up-time']>'00:00' && $data['pick-up-time'] < "05:00") {
										$data['pick_up_price'] = $taxi_prices[$obj_taxi_id]['price_double'.$trip_type];
									} else {
										$data['pick_up_price'] = $taxi_prices[$obj_taxi_id]['price_normal'.$trip_type];
									}


									$data['total_price'] = $data['pick_up_price'];

									 if ($data['return-journey']) {
										 if ($data['return-time']>'00:00' && $data['return-time'] < "05:00") {
			 									$data['return_price'] = $taxi_prices[$obj_taxi_id]['price_double'.$trip_type_return];
			 								} else {
			 									$data['return_price'] = $taxi_prices[$obj_taxi_id]['price_normal'.$trip_type_return];
			 								}

											$data['total_price'] += $data['return_price'];
									 }
									 ?>
									 <div class="taxi-wrapper" id ="taxi-<?php echo $taxi_id;?>">
										<div class="row">
											<div class="col-12 col-sm-3 ">
												<div class="taxi-thumb">
													<?php the_post_thumbnail('medium'); ?>
												</div>
											</div>
											<div class="col-12 col-sm-5 ">
												<div class="taxi-details">
													<h2><?php the_title();?></h2>
													<div class="sub-title"><?php the_content(); ?></div>
													<ul>
														<li><i class="fas fa-user"></i> <?php echo $post_meta['passengers'][0]; ?> <?php echo __('Passengers', 'taxiplon'); ?>
														</li>
														<li><i class="fas fa-suitcase"></i> <?php echo $post_meta['standard_bags'][0]; ?> <?php echo __('Standard Size Luggage', 'taxiplon'); ?>
														</li>
														<li>
															<i class="far fa-check-circle"></i><?php echo __('Meet & Greet included', 'taxiplon'); ?>
														</li>
														<li>
															<i class="fas fa-check"></i> <?php echo __('Free cancelation up to 2 hours before pick up', 'taxiplon'); ?>
														</li>
													</ul>
												</div>
											</div>
											<div class="col-12 col-sm-4 ">
												<div class="order-taxi-wrapper">
													<div class="price">
														<?php echo $data['total_price']; ?>&euro;
													</div>
													<div class="price-info">
														<h4>
															<?php if ($data['return-journey']) {
																echo __('Return price for all passengers', 'taxiplon');
															} else {
																echo __('One way price for all passengers', 'taxiplon');
															} ?>
														</h4>
														<p>
															<?php echo __('This is the total price you will pay for your trip', 'taxiplon'); ?>
														</p>
													</div>
													<div class="order-button">
														<?php
														$add_to_cart_extra = "";
														// Create link from $data array;
														foreach ($data as $key => $value) {
															$add_to_cart_extra .= "&amp;".$key."=".$value;
														}

														$extra_options_page = array();
														$extra_options_page['id'] 		= icl_object_id(67, 'page', false, ICL_LANGUAGE_CODE);
														$extra_options_page['link'] 	= get_permalink($extra_options_page['id']);
														//var_dump($current_page);
														?>
														<a href="<?php echo $extra_options_page['link'] ;?>?taxi_id=<?php echo $taxi_id ?>&amp;price=<?php echo $data['total_price'];?><?php echo $add_to_cart_extra;?>" class="btn btn-taxiplon btn-lg btn-block">
															<?php echo __('Book Now', 'taxiplon'); ?>
														</a>
													</div>
												</div>
											</div>
										</div>
									 </div>
									 <?php
								 }
								}
							}
							?>
						</div>
					</div>
					<div class="col-md-12 col-lg-4">
						<div class="search-sidebar available-cars">
							<?php get_template_part('templates/search-form', 'page' ); ?>
						</div>
					</div>


				</div>


			</main><!-- #main -->
	</div><!-- .row -->

</div><!-- Container end -->

</div><!-- Wrapper end -->

<?php get_footer(); ?>
