<?php
/**
 * Plugin Name: Orders Report
 * Description: Orders Report for electra taxiplon
 * Version: 1.0
 * Author:  Giannis Vasilopoulos
 * License: GPL2
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
require plugin_dir_path( __FILE__ ) . 'includes/class-orders-report.php';

class WP_Orders_Report{
    // Constructor
    function __construct() {
        
        add_action( 'admin_menu', array( $this, 'wpa_add_menu' ));
        register_activation_hook( __FILE__, array( $this, 'wpa_install' ) );
        register_deactivation_hook( __FILE__, array( $this, 'wpa_uninstall' ) );
    }
    
    /*
     * Actions perform at loading of admin menu
     */
    function wpa_add_menu() {
        $user = wp_get_current_user();
        $allowed_roles = array('callirhoe-athens-user', 'administrator', 'callirhoe-hotels-all');
        if( array_intersect($allowed_roles, $user->roles ) ) {  
            add_menu_page( 'Orders Report', 'Orders Report', 'read', 'orders-report-plugin', array(
                __CLASS__,
                'wpa_page_file_path'
            ), 'dashicons-visibility','2.2.9');
        }
        // add_submenu_page( string $parent_slug, string $page_title, string $menu_title, string $capability, string $menu_slug, callable $function = '' )
        
    }
    
    
    static function wpa_page_file_path() {
        static $myListTable;
        $actual_link = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
        
        if( ! isset($myListTable)) {
            require_once(ABSPATH . 'wp-admin/includes/class-wp-list-table.php');
            require_once(ABSPATH . 'wp-admin/includes/screen.php');
            require_once(ABSPATH . 'wp-admin/includes/class-wp-screen.php');
            require_once(ABSPATH . 'wp-admin/includes/template.php');
            $myListTable = new Orders_Report_List_Table();
        }
        if(isset( $_POST['report-taxiplon'] )){
            $myListTable->download();
        }
        echo '</pre><div class="wrap"><h1 style="font-weight: 600;font-size: 2em;">Orders Report</h1>';
        if( isset($_POST['s']) ){
            $myListTable->prepare_items($_POST['s']);
        } else {
            $myListTable->prepare_items();
        }
        //$myListTable->prepare_items();
        
     
        ?>
         <?php if(current_user_can('administrator') || current_user_can('callirhoe-hotels-all') ) {  ?>
            <div class="filter-select">
                <form action="/wp-admin/admin.php">
                	<input type="hidden" name="page" value="orders-report-plugin">
                	<select name="hotel">
                	 	<option value="all">Επίλεξε Ξενοδοχείο</option>	
                		<option value="The Athenian Callirhoe Exclusive Hotel">The Athenian Callirhoe Exclusive Hotel</option>
<!--                		<option value="Electra Metropolis">Electra Metropolis</option>-->
<!--        	       		<option value="Electra Palace">Electra Palace</option> -->
                	</select>
                	<button type="submit" class="button button-primary">
                		Submit
                	</button>
                
                </form>
            </div>
        <?php }else{
//            if(current_user_can('electra-palace-user') ) {
//                echo '<h2>Electra Palace Report</h2>';
//            }
            if(current_user_can('callirhoe-athens-user') ) {
                echo '<h2>The Athenian Callirhoe Exclusive Hotel</h2>';
            }
//            if(current_user_can('electra-metropolis-user') ) {
//                echo '<h2>Electra Metropolis Report</h2>';
//            }
        }?>
        
        <form method="post" action="<?= $actual_link; ?>">
    			<input type="hidden" name="report-taxiplon" value="download">
    			<button type="submit" class="button button-primary button-large" style="float:right">
            		Export
            	</button>
        </form>
        <form method="post">
			
            <input type="hidden" name="page" value="<?php echo $_REQUEST['page'] ?>">
        <?php
        
           // $myListTable->search_box('Search', 'search_id');
            $myListTable->display();
        
        echo '</form>';?>
        <form method="post" action="<?= $actual_link; ?>">
    			<input type="hidden" name="report-taxiplon" value="download">
    			<button type="submit" class="button button-primary button-large" style="float:right">
            		Export
            	</button>
        </form>
        </div> <!-- Close wrap of list table -->
        <?php 
    }
    
    
    /*
     * Actions perform on activation of plugin
     */
    function wpa_install() {
        
        
        
    }
    
    /*
     * Actions perform on de-activation of plugin
     */
    function wpa_uninstall() {
        
        
        
    }
    
}

new WP_Orders_Report();